<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Barryvdh\DomPDF\Facade\Pdf as PDF;
use DateTime;
use Illuminate\Support\Facades\File;
use Illuminate\Support\Facades\Http;

class PdfController extends Controller
{
    public function generatePdfAI(Request $request)
    {

        $retainerInvoiceId = $request->id;
        $app4 = json_decode(getUserDetails($GLOBALS['access_token'], "6265627000000524001"), true);
        if (!empty($app4['users'][0]['Signature'][0])) {
            $fileId = $app4['users'][0]['Signature'][0]['file_Id'];
            $image = getImagesDetails($GLOBALS['access_token'], $fileId);
        } else {
            $image = null;
        }
        $firstName = $app4['users'][0]['first_name'];
        $lastName = $app4['users'][0]['last_name'];
        $path = $image;
        $type = pathinfo($path, PATHINFO_EXTENSION);
        $data = file_get_contents($path);
        $base64 = 'data:image/' . $type . ';base64,' . base64_encode($data);
        $data = fetchRetainerInvoiceData($retainerInvoiceId, $GLOBALS['access_token']);
        $baseDate = !empty($data['date']) ? $data['date'] : null;
        $cfTerm = $data['custom_field_hash']['cf_term'] ?? null;
        $daysToAdd = 0;
        if (!empty($cfTerm)) {
            preg_match('/(\d+)\s*days/i', $cfTerm, $matches);
            $daysToAdd = isset($matches[1]) ? (int) $matches[1] : 0;
        }
        $newDate = null;
        if (!empty($baseDate)) {
            $newDate = (new DateTime($baseDate))->modify("+{$daysToAdd} days")->format('Y-m-d');
        }
        //  var_dump($data);
        // exit();
        // for reference
        $retainerstatus = $data['status'] ?? null;
        $retainerquotename = $data['custom_field_hash']['cf_quotes_name'];
        // $data = json_encode(fetchRetainerInvoiceData($retainerInvoiceId, $TOKEN));
        $customerId = $data['customer_id'];
        // echo $customerId;
        // exit();

        $customerData = fetchCustomersData($customerId, $GLOBALS['access_token']);
        // $customerData = json_encode(fetchCustomersData($customerId, $TOKEN));
        // var_dump($customerData);
        // exit();

        $salutation = $firstName = $lastName = "";

        // Loop through the contact_persons array
        foreach ($customerData['contact_persons'] as $contact) {
            if ($contact['is_primary_contact'] === true) {
                // Extract the data
                $salutation = $contact['salutation'];
                $firstName = $contact['first_name'];
                $lastName = $contact['last_name'];
                break; // Exit the loop after finding the first primary contact
            }
        }

        // Retrieve deal ID from query string
        // Check if payments array exists and has at least one element
        if (isset($data['payments'][0]['payment_id'])) {
            $paymentId = $data['payments'][0]['payment_id'];
        } else {
            $paymentId = null; // Or handle as needed, e.g., set a default value or throw a custom error
        }
        // echo $paymentId;
        // exit();

        if ($paymentId) {
            $paymentData = fetchPaymentData($paymentId, $GLOBALS['access_token']);
            // var_dump($paymentData);
            $paymenttype = $paymentData['payment_mode'] ?? ''; // Assign or set default
            $invoiceNumber = $paymentData['invoices']['0']['invoice_number'] ?? " ";
        } else {
            $paymentData = null;
            $paymenttype = ''; // Default if no payment ID or data
        }


        if ($retainerstatus == 'drawn') {
            $reference = " $retainerquotename, $invoiceNumber";
            // echo $reference;
            // exit();
        } else {
            $reference =  $invoiceNumber ?? " ";
        }
        $data_send = [
            'retainerInvoiceId' => $retainerInvoiceId,
            'app4' => $app4,
            'fileId' => $fileId ?? null,
            'image' => $image ?? null,
            'firstName' => $firstName,
            'lastName' => $lastName,
            'path' => $path ?? null,
            'type' => $type ?? null,
            'base64' => $base64 ?? null,
            'data' => $data,
            'baseDate' => $baseDate,
            'cfTerm' => $cfTerm,
            'daysToAdd' => $daysToAdd,
            'newDate' => $newDate,
            'retainerstatus' => $retainerstatus,
            'retainerquotename' => $retainerquotename,
            'customerId' => $customerId,
            'customerData' => $customerData,
            'salutation' => $salutation,
            'paymentId' => $paymentId,
            'paymentData' => $paymentData,
            'paymenttype' => $paymenttype,
            'invoiceNumber' => $invoiceNumber,
            'reference' => $reference,
        ];

        ////uncomment to view html
        // return view('pdf_ai_thai', $data_send);
        // exit();
        // Load the Blade view and pass data
        $pdf = PDF::loadView('pdf_ai_thai', $data_send);
        return $pdf->stream($reference.'.pdf');
        exit();
        // Define the file name and path to save the PDF
        $filePath = public_path('pdfs/'.$reference.'.pdf'); // Save in the `public/pdfs` folder

        // Ensure the `pdfs` directory exists
        if (!File::exists(public_path('pdfs'))) {
            File::makeDirectory(public_path('pdfs'), 0755, true);
        }

        // Save the PDF to the specified path
        $pdf->save($filePath);

        // Optional: Return the file as a response to the browser
        return response()->download($filePath);
        // echo $GLOBALS['access_token'];
    }

    public function generateInvoice(Request $request)
    {
        $url = 'http://191.101.229.210:57998/generate-pdf-invoice';
        $params = [
            'quote_no' => $request->quote_no,
            'version' => $request->version,
        ];

        try {
            // Send the GET request and wait for the response
            $response = Http::get($url, $params);

            // Check if the response is successful
            if ($response->successful()) {
                // Handle the successful response
                return $response->body(); // Or process the data as needed
            }

            // Handle non-2xx responses
            return response()->json(['error' => 'Failed to generate invoice', 'details' => $response->body()], $response->status());
        } catch (\Exception $e) {
            // Handle exceptions
            return response()->json(['error' => 'An error occurred while generating the invoice', 'message' => $e->getMessage()], 500);
        }
    }

    public function generateRI(Request $request)
    {
        $url = 'http://191.101.229.210:57998/generate-pdf-ai';
        $params = [
            'quote_no' => $request->quote_no,
            'version' => $request->version,
        ];

        try {
            // Send the GET request and wait for the response
            $response = Http::get($url, $params);

            // Check if the response is successful
            if ($response->successful()) {
                // Handle the successful response
                return $response->body(); // Or process the data as needed
            }

            // Handle non-2xx responses
            return response()->json(['error' => 'Failed to generate invoice', 'details' => $response->body()], $response->status());
        } catch (\Exception $e) {
            // Handle exceptions
            return response()->json(['error' => 'An error occurred while generating the invoice', 'message' => "error"], 500);
        }
    }

    public function generateSO(Request $request)
    {
        $url = 'http://191.101.229.210:57998/generate-pdf-so';
        $params = [
            'quote_no' => $request->quote_no,
            'version' => $request->version,
        ];

        try {
            // Send the GET request and wait for the response
            $response = Http::get($url, $params);

            // Check if the response is successful
            if ($response->successful()) {
                // Handle the successful response
                return $response->body(); // Or process the data as needed
            }

            // Handle non-2xx responses
            return response()->json(['error' => 'Failed to generate invoice', 'details' => $response->body()], $response->status());
        } catch (\Exception $e) {
            // Handle exceptions
            return response()->json(['error' => 'An error occurred while generating the invoice', 'message' => "error"], 500);
        }
    }

    public function generateDeal(Request $request)
    {
        $url = 'http://191.101.229.210:57998/generate-pdf';
        $params = [
            'quote_no' => $request->quote_no,
            'version' => $request->version,
            'ver'=>$request->ver,
        ];

        try {
            // Send the GET request and wait for the response
            $response = Http::get($url, $params);

            // Check if the response is successful
            if ($response->successful()) {
                // Handle the successful response
                return $response->body(); // Or process the data as needed
            }

            // Handle non-2xx responses
            return response()->json(['error' => 'Failed to generate invoice', 'details' => $response->body()], $response->status());
        } catch (\Exception $e) {
            // Handle exceptions
            return response()->json(['error' => 'An error occurred while generating the invoice', 'message' => "error"], 500);
        }
    }


}
